#include "pch.h"
#include "GpibContec.h"
#include "gpibac.h"
#include "SubFunc.h"

// RXgN^
CGpibContec::CGpibContec()
	: m_DeviceAddress(0)
	, m_ReceiveData(_T(""))
	, m_MyAddress(0)
{
}

// fXgN^
CGpibContec::~CGpibContec()
{
}

// (1)ڑ
BOOL CGpibContec::OpenInterface(DWORD PrimaryAddress)
{
	DWORD Mode;
	DWORD Eoi;
	DWORD Delim;
	CString ErrorMessage;
	DWORD Result;

	Result = static_cast<DWORD>(GpibInit(&ErrorMessage));								// GPIB̏
	if (Result != 0) {
		MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	Result = GpBoardsts(0x0a, &Mode);													// }X^/X[u[h̓ǂݏo
	if (Result != 0) {
		CheckRet(CString(_T("GpBoardsts")), Result, &ErrorMessage);						// GpBoardsts̖߂l`FbN
		MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}
	if (Mode != 0) {
		MessageBox(NULL, _T("̋@̓}X^ł͂܂B"), AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	Result = GpBoardsts(0x08, &m_MyAddress);											// }CAhX̎擾
	if (Result != 0) {
		CheckRet(CString(_T("GpBoardsts")), Result, &ErrorMessage);						// GpBoardsts̖߂l`FbN
		MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	Eoi = 1;																			// 0:gpȂ / 1:gp
	Delim = 3;																			// 0:gp / 1:CR+LF / 2:CR / 3:LF
	Result = GpDelim(Delim, Eoi); 														// f~^R[h(EOI)o̐ݒ
	if (Result != 0) {
		CheckRet(CString(_T("GpDelim")), Result, &ErrorMessage);						// GpDelim̖߂l`FbN
		MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	Result = GpTimeout(1000);															// ^CAEgԂ̐ݒ
	if (Result != 0) {
		CheckRet(CString(_T("GpTimeout")), Result, &ErrorMessage); 						// GpTimeout̖߂l`FbN
		MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	m_DeviceAddress = static_cast<long>(PrimaryAddress);

	return TRUE;
}

// (2)ؒf
BOOL CGpibContec::CloseInterface()
{
	GpibExit();																			// GPIB̏I

	return TRUE;
}

// (3)R}hM
BOOL CGpibContec::SendMsg(CString SendData)
{
	long Result;

	Result = GpibPrint(m_DeviceAddress, SendData);										// Mf[^
	if (Result != 0) {
		return FALSE;
	}

	return TRUE;
}

// (4)M
BOOL CGpibContec::ReceiveMsg(DWORD Timeout)
{
	CString Buffer;
	CString ErrorMessage;
	long Result;

	Result = GpTimeout(Timeout);														// ^CAEgԂ̐ݒ
	if (Result != 0) {
		CheckRet(CString(_T("GpTimeout")), Result, &ErrorMessage); 						// GpTimeout̖߂l`FbN
		MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	Result = GpibInputHioki(m_DeviceAddress, &Buffer);									// Mobt@ɓǂݍ
	if (Result != 0) {
		m_ReceiveData = _T("Error");
		return FALSE;
	}
	m_ReceiveData = Buffer;																// Mf[^ۑ

	return TRUE;
}

// (5)R}hM
BOOL CGpibContec::SendQueryMsg(CString SendData, DWORD Timeout)
{
	BOOL Result;

	Result = SendMsg(SendData);															// R}hM
	if (Result == TRUE) {
		if (SendData.Find(_T("?")) != -1) {
			Result = ReceiveMsg(Timeout);												// M牞M
		}
	}

	return Result;
}
